/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;


import com.arsdigita.toolbox.util.GlobalizationUtil ; 

import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.globalization.Globalized;
import java.util.Date;

/**
 * 
 * This displays the date and time in a standard format within a TableCell.
 *
 * @author Bryan Quinmn 
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DateTimeTableCellRenderer.java#10 $
 */
public class DateTimeTableCellRenderer implements Globalized, TableCellRenderer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DateTimeTableCellRenderer.java#10 $";

    public Component getComponent(Table table, PageState state, Object value,
                                  boolean isSelected, Object key,
                                  int row, int column) {
        if (value == null) {
            // if there is not a value then there is nothing to display
            return new Label(GlobalizationUtil.globalize("toolbox.ui.na"));
        } else {
            return new Label(FormatStandards.formatDateTime((Date)value));
        }
    }
}
