/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/**
 * <p>A simple layout panel with top, bottom, left, right, and body
 * sections.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ActionGroup.java#10 $
 */
public class ActionGroup extends ComponentSet {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ActionGroup.java#10 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ActionGroup.class);

    private Component m_subject;
    private final ArrayList m_actions = new ArrayList();

    public static final String ADD = "add";
    public static final String EDIT = "edit";
    public static final String DELETE = "delete";
    public static final String RETURN = "return";

    public final void setSubject(final Component subject) {
        Assert.assertNotNull(subject, "Component subject");
        Assert.assertNotLocked(this);

        m_subject = subject;
        add(m_subject);
    }

    public final void addAction(final Component action, final String clacc) {
        Assert.assertNotNull(action, "Component action");
        Assert.assertNotLocked(this);

        m_actions.add(new Object[] {action, clacc});
        add(action);
    }

    public final void addAction(final Component action) {
        addAction(action, null);
    }

    public final void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final Element layout = parent.newChildElement
                ("bebop:actionGroup", BEBOP_XML_NS);

            final Element subject = layout.newChildElement
                ("bebop:subject", BEBOP_XML_NS);

            if (m_subject != null) {
                m_subject.generateXML(state, subject);
            }

            for (Iterator iter = m_actions.iterator(); iter.hasNext(); ) {
                final Object[] spec = (Object[]) iter.next();
                final Component component = (Component) spec[0];
                final String clacc = (String) spec[1];

                if (component.isVisible(state)) {
                    final Element action = layout.newChildElement
                        ("bebop:action", BEBOP_XML_NS);

                    if (clacc != null) {
                        action.addAttribute("class", clacc);
                    }

                    component.generateXML(state, action);
                }
            }
        }
    }
}
