/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.util.URLRewriter;
import org.apache.log4j.Logger;

/**
 * <p>
 * Add the character set encoding provider.
 * </p>
 *
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class CharsetEncodingProviderInitializer implements Initializer {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/CharsetEncodingProviderInitializer.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(CharsetEncodingProviderInitializer.class);

    private Configuration m_conf = new Configuration();

    public CharsetEncodingProviderInitializer() throws InitializationException {
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void startup() {
        setCharsetEncodingProvider();
    }

    public void shutdown() {
    }

    private void setCharsetEncodingProvider() {
        URLRewriter.addParameterProvider(new CharsetEncodingProvider());
    }
}
