/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * <p>
 * This is the "legacy" stylesheet resolver class. It resolves stylesheets
 * using the old packagetype <-> stylesheet and sitenode <-> stylesheet
 * mappings in the database.
 * </p>
 *
 * @deprecated use {@link PatternStylesheetResolver} in new code.
 */
public class LegacyStylesheetResolver implements StylesheetResolver {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/templating/LegacyStylesheetResolver.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (LegacyStylesheetResolver.class);


    public URL resolve(HttpServletRequest request) {
        //    TransactionContext tctx =
        //      SessionManager.getSession().getTransactionContext();
        //    boolean callerStartedTransaction = tctx.inTxn();
        //    if (!callerStartedTransaction)
        //      tctx.beginTxn();

        // Get the site node.
        final SiteNodeRequestContext context = (SiteNodeRequestContext)
            DispatcherHelper.getRequestContext(request);

        final Locale locale = context.getLocale();
        final String output = context.getOutputType();
        final SiteNode node = context.getSiteNode();

        SiteNode sn = node;
        Stylesheet ss = null;

        while (sn != null && ss == null) {
            // No style for this site node, but we can try the parent.
            ss = sn.getStylesheet(locale, output);
            sn = sn.getParent();
        }

        sn = node;

        while (sn != null && ss == null) {
            final PackageInstance pi = sn.getPackageInstance();

            if (pi != null) {
                ss = pi.getType().getStylesheet(locale, output);
            }

            sn = sn.getParent();
        }

        if (ss == null) {
            throw new IllegalStateException
                ("No path to XSL stylesheet found");
        }

        // Get the actual path for the Stylesheet we've found.
        final String filename = ss.getPath();

        if (s_log.isDebugEnabled()) {
            s_log.debug("Trying path " + filename);
        }


        try {
            return new URL(Web.getConfig().getDefaultScheme(),
                           Web.getConfig().getHost().getName(),
                           Web.getConfig().getHost().getPort(),
                           filename);
        } catch (MalformedURLException ex) {
            throw new UncheckedWrapperException(ex);
        }
    }
}
