/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Web;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;


/**
 * Generates a set of patterns corresponding to the current 
 * web application prefix
 */
public class HostPatternGenerator implements PatternGenerator {

    private static final Logger s_log = 
         Logger.getLogger(URLPatternGenerator.class);

    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        HttpHost host = Web.getConfig().getHost();
        
        return new String[] { host.toString() };
    }
}
