/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.ui.StaticFilterComponent;
import com.arsdigita.search.filters.PermissionFilterSpecification;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.bebop.PageState;

public class PermissionFilterComponent extends StaticFilterComponent {

    private PrivilegeDescriptor m_priv;

    public PermissionFilterComponent(PrivilegeDescriptor priv) {
        m_priv = priv;
    }

    public PermissionFilterComponent(String privilege) {
        this(PrivilegeDescriptor.get(privilege));
    }

    
    public FilterSpecification getFilter(PageState state) {
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            // There is no logged-in user, so filter based on permissions
            // granted to "the public".
            party = Kernel.getPublicUser();
        }

        return new PermissionFilterSpecification(
            party,
            m_priv
        );
    }

}
