/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.runtime.CCM;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;

import java.io.File;

/**
 * LuceneConfig
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public class LuceneConfig extends AbstractConfig {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/LuceneConfig.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static LuceneConfig s_conf;

    static synchronized LuceneConfig getConfig() {
        if (s_conf == null) {
            s_conf = new LuceneConfig();
            s_conf.load("ccm-core/lucene.properties");
        }

        return s_conf;
    }

    private StringParameter m_location = new StringParameter
        ("waf.lucene.location", Parameter.REQUIRED,
         new File(CCM.getDataDirectory(), "lucene").getPath());
    private IntegerParameter m_interval = new IntegerParameter
        ("waf.lucene.interval", Parameter.REQUIRED, new Integer(2*60));

    public LuceneConfig() {
        register(m_location);
        register(m_interval);
        loadInfo();
    }

    public String getIndexLocation() {
        return (String) get(m_location);
    }

    public int getIndexerInterval() {
        return ((Integer) get(m_interval)).intValue();
    }
}
