/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;


import org.apache.lucene.search.Filter;
import org.apache.lucene.index.IndexReader;

import java.util.BitSet;
import java.io.IOException;

import org.apache.log4j.Logger;


/**
 * A filter whose bitset corresponds to the
 * logical AND of the bitsets from the wrapped filters.
 * Thus it selects the intersection of results selected 
 * by each wrapped filter.
 */
public class IntersectionFilter extends Filter {

    private static final Logger s_log = 
        Logger.getLogger(IntersectionFilter.class);
    
    private Filter[] m_filters;
    
    public IntersectionFilter(Filter[] filters) {
        m_filters = filters;
    }
    /**
     * @return bitset for the AND of all wrapped filters
     */
    public BitSet bits(IndexReader reader)
        throws IOException {
        
        BitSet bits = new BitSet(reader.maxDoc());
        
        for (int i = 0 ; i < m_filters.length ; i++) {
            if (s_log.isDebugEnabled()) {
                s_log.debug("Adding filter " + m_filters[i].getClass());
            }
            // First filter is special since bit sets
            // start off with no bits set.
            if (i == 0) {
                bits.or(m_filters[i].bits(reader));
            } else {
                bits.and(m_filters[i].bits(reader));
            }
        }
        
        return bits;
    }
}
