/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.DedicatedConnectionSource;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.jdbc.Connections;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

import java.sql.Connection;
import java.util.TimerTask;


/**
 * The TimerFinished class provides the method that is scheduled
 * by the timer created by BuildIndex.  It simply calls the
 * timerFinished method of BuildIndex.
 *
 * @author Jeff Teeters
 * @version 1.0
 **/
class TimerFinished extends TimerTask {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/TimerFinished.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger(TimerFinished.class);
    public void run() {

        TransactionContext txn = getTransaction();
        txn.beginTxn();

        try {
            BuildIndex.checkState();
        } catch(Exception e) {
            s_log.error("BuildIndex.checkState() failed!", e);
            txn.abortTxn();
            return;
        }

        txn.commitTxn();
    }

    private TransactionContext getTransaction() {
        Session ssn = SessionManager.getSession();
        Assert.exists(ssn, Session.class);
        return ssn.getTransactionContext();
    }
}
