/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.filters;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.util.Assert;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;

/**
 * A filter spec for supplying two dates (start & end) 
 * for filtering on the item's launch date.
 */
public class PartyFilterSpecification extends FilterSpecification {

    public final static String SEARCH_TERM = "searchTerm";
    public final static String PARTIES = "parties";

    /**
     * Creates a new filter restricting results to have
     * a launch date within a given range, inclusive.
     *
     * @param start the start date
     * @param end the end date
     */
    public PartyFilterSpecification(PartyCollection parties,
                                    FilterType filterType) {
        super(new Object[] { PARTIES, parties},
              filterType);
    }
    
    /**
     * Start of the date range for filtering
     * @return the start date
     */
    public PartyCollection getParties() {
        return (PartyCollection)get(PARTIES);
    }
}
