/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.converter;

import java.io.InputStream;
import java.io.IOException;
import java.io.ByteArrayOutputStream;
import org.textmining.text.extraction.WordExtractor;

/**
 * this class exists to ensure that text attachments are also indexed.
 */
public class TextConverter extends BaseConverter {
    
    /**
     *  Returns a string array representing all of the files types
     *  used by the given converter
     */
    protected String[] getFileExtensions() {
        String[] extensions = {"txt", "html", "htm", "text", "c", "cc", "c++", "h", "pl", "java", "sgm", "sgml", "jsp", "xml"};
        return extensions;
    }

    /**
     *  This takes in a document represented as an InputStream and returns
     *  a text representation of that document.
     */
    public String convertDocument(InputStream stream) throws ConversionException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int position;
            
            while ((position = stream.read(buf)) != -1) {
                output.write(buf, 0, position);
            }
            return output.toString();
        } catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    /** 
     *  This takes in a document represented as a byte[] and returns
     *  a text representation of that document.
     */
    public String convertDocument(byte[] document) {
        return new String(document);
    }
} 
