/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.converter;

import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

/**
 * An exception to indicate that a problem occurred while trying to 
 * convert the contents of the document to text.
 */
public class ConversionException extends UncheckedWrapperException {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/converter/ConversionException.java#1 $";


    /**
     * Constructor which only takes a msg, which will cause this
     * ConversionException to behave like a normal RuntimeException.
     * While it doesn't seem to make a lot of sense to have a wrapper
     * exception that doesn't wrap anything, this is needed so that it
     * can be used as a direct replacement for RuntimeException.
     */
    public ConversionException (String msg) {
        super(msg);
    }

    /**
     * Constructor which takes a root cause
     * that this exception will be wrapping.
     */
    public ConversionException (Throwable rootCause) {
        super(rootCause);
    }

    /**
     * Constructor which takes a message string and a root cause
     * that this exception will be wrapping.  The message string
     * should be something different than rootCause.getMessage()
     * would normally provide.
     */
    public ConversionException (String s, Throwable rootCause) {
        super(s, rootCause);
    }

}
