/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.persistence.Session;
import com.arsdigita.util.parameter.ParameterLoader;

/**
 * The ScriptContext class is passed into the {@link
 * Script#run(ScriptContext)} method in order to provide an instance
 * of the {@link Script} interface access to the proper context in
 * which to execute.
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

public class ScriptContext {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/ScriptContext.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final Session m_ssn;
    private final ParameterLoader m_params;

    /**
     * Constructs a new ScriptContext object with the given Session
     * and ParameterLoader.
     *
     * @param ssn The persistent session to provide to the executing
     * script.
     *
     * @param params The parameter loader to provide to the executing
     * script.
     **/

    public ScriptContext(Session ssn, ParameterLoader params) {
        m_ssn = ssn;
        m_params = params;
    }

    /**
     * Returns the persistent session for this ScriptContext.
     *
     * @return a persistent session
     **/

    public Session getSession() {
        return m_ssn;
    }

    /**
     * @deprecated Use {@link com.arsdigita.util.parameter.ParameterContext#load(com.arsdigita.util.parameter.ParameterReader, com.arsdigita.util.parameter.ErrorList)} instead.
     **/

    public ParameterLoader getParameterLoader() {
        return m_params;
    }

}
