/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.UncheckedWrapperException;
//import com.arsdigita.util.*;
//import com.arsdigita.util.jdbc.*;
//import com.arsdigita.util.parameter.*;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
//import java.sql.*;
//import java.util.*;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * An entry-point class for functions of the CCM runtime package.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/CCM.java#4 $
 */
public final class CCM {
    private static final Logger s_log = Logger.getLogger(CCM.class);

    public static final URL getHomeURL() {
        try {
            return CCM.getHomeDirectory().toURL();
        } catch (MalformedURLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    static final File getHomeDirectory() {
        final String home = System.getProperty("ccm.home");

        if (home == null) {
            throw new IllegalStateException
                ("The ccm.home system property is null or not defined");
        }

        final File file = new File(home);

        if (!file.exists()) {
            throw new IllegalStateException
                ("The file given in the ccm.home system property " +
                 "does not exist");
        }

        if (!file.isDirectory()) {
            throw new IllegalStateException
                ("The file given in the ccm.home system property " +
                 "is not a directory");
        }

        return file;
    }

    public static final URL getConfigURL() {
        try {
            return CCM.getConfigDirectory().toURL();
        } catch (MalformedURLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static final File getConfigDirectory() {
        final String conf = System.getProperty("ccm.conf");

        File file;
        if (conf == null) {
            file = new File(new File(CCM.getHomeDirectory(),"conf"), "registry");
        } else {
            file = new File(conf);
        }

        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IllegalStateException
                    ("Could not create configuration directory: " + file);
            }
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException
                ("Configuration directory value is not a directory: " + file);
        }

        return file;
    }

    public static final File getDataDirectory() {
        File file = new File(CCM.getHomeDirectory(),"data");
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IllegalStateException
                    ("Could not create data directory: " + file);
            }
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException
                ("Data directory value is not a directory: " + file);
        }
        return file;
    }
}
