/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal;

import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceSetup;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import org.apache.log4j.Logger;

/**
 *
 *
 * Initializes the portal package.
 *
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/portal/Initializer.java#11 $
 */
public class Initializer implements com.arsdigita.initializer.Initializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/Initializer.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(Initializer.class);

    private Configuration m_conf = new Configuration();

    public Initializer() throws InitializationException {
        /* Empty */
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void startup() {
        DomainObjectFactory.registerInstantiator
            (Portal.BASE_DATA_OBJECT_TYPE, new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new Portal(dataObject);
                }
            });
    }

    public void shutdown() {
        /* Empty */
    }

}
