/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.portlets;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.arsdigita.populate.Utilities;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.Portlet;

/**
 * @author bche
 */
public class PopulatePortlets {
    private static Logger s_log = Logger.getLogger(PopulatePortlets.class);    
    private PopulatePortletCollection m_PopPortlets;

    /**
     * Creates a new PopulatePortlets.  Takes in a collection of PopulatePortlets to
     * use in populating a portal
     * @param popPortletsthe collection of PopulatePortlets to use in populating a portal
     */        
    public PopulatePortlets(PopulatePortletCollection popPortlets) {
        m_PopPortlets = popPortlets;
    }

    /**
     * Populates portal with portlets using this object's collection of PopulatePortlets
     * @param iNumPortlets the number of instances of each portlet to add
     * @param portal the portal to populate
     * @return a list of BigDecimal ID's of all the portlets created
     */        
    public List populate(int iNumPortlets, Portal portal) {                        
        int iSize  = m_PopPortlets.getSize();
        int iTotalSize = iNumPortlets * iSize;
        s_log.info("Creating " + iNumPortlets + " instaces of " + iSize + " portlets for a total of " +
            iTotalSize + " portlets");

        ArrayList portlets = new ArrayList(iTotalSize);
                
        //iterate through populate apps
        for (int i=0; i < iSize; i++) {
            PopulatePortlet popPortlet = m_PopPortlets.getPopulatePortlet(i);            
            
            for (int j=0; j < iNumPortlets; j++) {       
                //use cell number of 1 for now                         
                popPortlet.createPortlet(portal, 1);
                popPortlet.populatePortlet();
                Portlet portlet = popPortlet.getPortlet();
                s_log.info("added portlet of type " + popPortlet.getPortletType().getTitle() + " to portal " + portal.getTitle());                             
                portlets.add(portlet.getID());           
            }                        
        }
        return portlets;
    }        
}
