/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.apps;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.populate.PopulateUsers;
import com.arsdigita.util.Assert;

/**
 * @author bche
 */
public class Initializer extends BaseInitializer {
	private static final Logger s_log =
		Logger.getLogger(Initializer.class.getName());
	private Configuration m_conf = new Configuration();

	/* (non-Javadoc)
	 * @see com.arsdigita.initializer.Initializer#getConfiguration()
	 */
	public Configuration getConfiguration() {
                m_conf.initParameter("baseStringSeed",
                        "The base string seed to use for generating String names.",
                        String.class,
                        null);        
		m_conf.initParameter(
			"numApps",
			"the number of instances to create for each application",
			Integer.class);
		m_conf.initParameter(
			"PopulateAppPair",
			"A list pair, consisting of the PopulateApp class with which to populate and"
				+ "the arguments for that class",
			List.class);
		return m_conf;
	}

	/* (non-Javadoc)
	 * @see com.arsdigita.kernel.BaseInitializer#doStartup()
	 */
	protected void doStartup() {
                String sBaseStringSeed = (String)m_conf.getParameter("baseStringSeed");        
		int iApps = ((Integer) m_conf.getParameter("numApps")).intValue();
		List popAppsList = ((List) m_conf.getParameter("PopulateAppPair"));
		
                if (s_log.isDebugEnabled()) {
                    s_log.debug("iApps: " + iApps);
                    s_log.debug("popAppsList: " + popAppsList);
                    s_log.debug("Using BaseStringSeed " + sBaseStringSeed);
                }

		PopulateAppPairCollection popAppsColl = new PopulateAppPairCollection();

		int iSize = popAppsList.size();
		for (int i = 0; i < iSize; i++) {
			List popAppParam = (List) popAppsList.get(i);
			Assert.assertTrue(popAppParam.size() == 2);

			String sPopApp = (String) popAppParam.get(0);
			s_log.debug("PopulateApp is " + sPopApp);
			PopulateApp popApp;
			try {
				popApp = (PopulateApp) Class.forName(sPopApp).newInstance();
			} catch (Exception e) {
				throw new InitializationException(e.getMessage());
			}
			List args = (List) popAppParam.get(1);
			s_log.debug("args are" + args);
			PopulateAppPair popAppPair = new PopulateAppPair(popApp, args);
			popAppsColl.addPopulateApp(popAppPair);
		}

		//create the apps
		s_log.info("Begin populating applications");

		PopulateApps popApps = new PopulateApps(popAppsColl);
                popApps.setBaseStringSeed(sBaseStringSeed);
		popApps.populate(iApps);
		s_log.info("End populating applications");
	}

	/* (non-Javadoc)
	 * @see com.arsdigita.kernel.BaseInitializer#doShutdown()
	 */
	protected void doShutdown() {
	}

}
