/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.apps;

import org.apache.log4j.Logger;

import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public abstract class AbstractPopulateApp implements PopulateApp {
    private Application m_app = null;
    private AppPortlet m_portlet = null;
    private String m_sBaseStringSeed = null;
    protected Logger s_log = Logger.getLogger(PopulateApp.class);

    private Application createAppInstance(String sTitle, Application parent) {
        return Application.createApplication(getAppType(), sTitle, sTitle, parent);
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#setBaseStringSeed(java.lang.String sSeed)
     */
    public void setBaseStringSeed(String sSeed) {
        m_sBaseStringSeed = sSeed;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getBaseStringSeed()
     */
    public String getBaseStringSeed() {
        return m_sBaseStringSeed;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#createApp(java.lang.String, com.arsdigita.web.Application)
     */
    public void createApp(String sTitle, Application parent) {
        m_app = createAppInstance(sTitle, parent);
        m_portlet = null;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#populateApp(java.util.List args)
     */
    public abstract void populateApp(java.util.List args);

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getArgsDescription()
     */
    public abstract String getArgsDescription();

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getApp()
     */
    public Application getApp() {
        return m_app;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getAppType()
     */
    public abstract ApplicationType getAppType();

    /**
     * Checks that the number of arguments in args is equal to numArgs.  
     * Also checks that the args are all ints.  Throws
     * an IllegalArgumentException with sMsg if args not valid
     * @param args List of arguments to check
     * @param numArgs how many arguments should be there
     * @param sMsg message to throw if the number of arguments is wrong
     * @throws IllegalArgumentException
     */
    protected void validateArgs(java.util.List args, int numArgs, String sMsg)
        throws IllegalArgumentException {
        int iSize = args.size();
        s_log.debug("args size is " + iSize);
        if (iSize != numArgs) {
            throw new IllegalArgumentException("wrong number of args; " + sMsg);
        }
        for (int i = 0; i < iSize; i++) {
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("arg is a " + args.get(i).getClass());
                }
                Integer arg = (Integer) args.get(i);
            } catch (Exception e) {
                throw new IllegalArgumentException("args not all ints; " + sMsg);
            }
        }
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getPortlet()
     */
    public AppPortlet getPortlet() {
        if (m_portlet == null && m_app != null) {
            m_portlet = (AppPortlet) Portlet.createPortlet(getPortletType(), m_app);
            if (s_log.isDebugEnabled()) {
                s_log.debug(
                    "setting m_portlet to "
                        + m_portlet.getTitle()
                        + " with id "
                        + m_portlet.getID());
            }
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug(
                "getting portlet "
                    + m_portlet.getTitle()
                    + " with id "
                    + m_portlet.getID());
        }
        return m_portlet;
    }

    /**
     * Returns the BaseDataObjectType of the portlet that getPortlet() returns
     * @return the BaseDataObjectType of the portlet that getPortlet() returns
     */
    protected abstract String getPortletType();
}
