/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.persistence.*;
import com.arsdigita.runtime.*;

/**
 * Status
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

class Status extends Command {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Status.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Status() {
        super("status", "Report on the status of a CCM instance");
    }

    public boolean run(String[] args) {
        String[] packages;
        if (args.length == 0) {
            RegistryConfig rc = new RegistryConfig();
            rc.load();
            packages = rc.getPackages();
        } else {
            packages = args;
        }

        if (packages.length == 0) { return true; }

        Checklist[] checks = new Checklist[packages.length];
        for (int i = 0; i < packages.length; i++) {
            checks[i] = Checklist.get(packages[i]);
        }

        boolean passed = true;
        for (int i = 0; i < checks.length; i++) {
            if (checks[i] != null) {
                passed &= checks[i].run
                    (Checklist.SCHEMA, new ScriptContext(null, null));
            }
        }
        if (!passed) { return false; }

        new Startup().run();
        Session ssn = SessionManager.getSession();

        for (int i = 0; i < checks.length; i++) {
            if (checks[i] != null) {
                passed &= checks[i].run
                    (Checklist.DATA, new ScriptContext(ssn, null));
            }
        }
        if (!passed) { return false; }

        for (int i = 0; i < checks.length; i++) {
            if (checks[i] != null) {
                passed &= checks[i].run
                    (Checklist.STARTUP, new ScriptContext(ssn, null));
            }
        }
        if (!passed) { return false; }

        return true;
    }

}
