/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.xml.XML;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * LoaderInfo
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

class LoaderInfo {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/LoaderInfo.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private List m_requiredTables = new ArrayList();
    private List m_providedTables = new ArrayList();
    private List m_requiredInitializers = new ArrayList();
    private List m_providedInitializers = new ArrayList();
    private List m_schemaScripts = new ArrayList();
    private List m_dataScripts = new ArrayList();
    private List m_requiredPackages = new ArrayList();

    public LoaderInfo(InputStream is) {
        XML.parse(is, new LoaderInfoHandler());
    }

    public List getRequiredTables() {
        return m_requiredTables;
    }

    public List getProvidedTables() {
        return m_providedTables;
    }

    public List getRequiredInitializers() {
        return m_requiredInitializers;
    }

    public List getProvidedInitializers() {
        return m_providedInitializers;
    }

    public List getRequiredPackages() {
        return m_requiredPackages;
    }

    public List getSchemaScripts() {
        return m_schemaScripts;
    }

    public List getDataScripts() {
        return m_dataScripts;
    }

    private static final String PROVIDES = "provides";
    private static final String REQUIRES = "requires";
    private static final String TABLE = "table";
    private static final String INITIALIZER = "initializer";
    private static final String PACKAGE = "package";
    private static final String SCRIPTS = "scripts";
    private static final String SCHEMA = "schema";
    private static final String DATA = "data";

    // attributes
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String DIRECTORY = "directory";

    private class LoaderInfoHandler extends DefaultHandler {

        private List m_context = new ArrayList();

        public void startElement(String uri, String name, String qn,
                                 Attributes attrs) {
            if (name.equals(TABLE)) {
                String table = attrs.getValue(uri, NAME);
                if (table == null) {
                    throw new IllegalStateException
                        ("table element requires name attribute");
                }

                if (m_context.contains(REQUIRES)) {
                    m_requiredTables.add(table);
                } else if (m_context.contains(PROVIDES)) {
                    m_providedTables.add(table);
                } else {
                    throw new IllegalStateException
                        ("table element must appear inside " +
                         "requires or provides");
                }
            }

            if (name.equals(INITIALIZER)) {
                String init = attrs.getValue(uri, CLASS);
                if (init == null) {
                    throw new IllegalStateException
                        ("init element requires class attribute");
                }

                if (m_context.contains(REQUIRES)) {
                    m_requiredInitializers.add(init);
                } else if (m_context.contains(PROVIDES)) {
                    m_providedInitializers.add(init);
                } else {
                    throw new IllegalStateException
                        ("initializer element must appear inside " +
                         "requires or provides");
                }
            }

            if (name.equals(PACKAGE)) {
                String key = attrs.getValue(uri, NAME);
                if (key == null) {
                    throw new IllegalStateException
                        ("package element requires name attribute");
                }
                if (m_context.contains(REQUIRES)) {
                    m_requiredPackages.add(key);
                } else {
                    throw new IllegalStateException
                        ("package element must appear inside requires");
                }
            }

            if (name.equals(SCHEMA)) {
                if (!m_context.contains(SCRIPTS)) {
                    throw new IllegalStateException
                        ("schema element must appear inside scripts");
                }

                String dir = attrs.getValue(uri, DIRECTORY);
                if (dir == null) {
                    throw new IllegalStateException
                        ("schema element requires directory attribute");
                }

                m_schemaScripts.add(dir);
            }

            if (name.equals(DATA)) {
                if (!m_context.contains(SCRIPTS)) {
                    throw new IllegalStateException
                        ("data element must appear inside scripts");
                }

                String klass = attrs.getValue(uri, CLASS);
                if (klass == null) {
                    throw new IllegalStateException
                        ("data element requires class attribute");
                }

                m_dataScripts.add(klass);
            }

            m_context.add(name);
        }

        public void endElement(String uri, String name, String qn) {
            m_context.remove(m_context.lastIndexOf(name));
        }
    }

}
