/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes.util;

import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.globalization.Globalized;

/**
 * <p>
 * .
 * Contains methods to simplify globalizing keys
 * </p>
 *
 * @author <a href="mailto:yon@arsdigita.com">yon@arsdigita.com</a>
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 */

public class GlobalizationUtil implements Globalized {

    private static final String BUNDLE_NAME = "com.arsdigita.mimetypes.MimeTypeResources";
    
    public static GlobalizedMessage globalize(String key) {
	 return new GlobalizedMessage(key, BUNDLE_NAME);
     }
    public static GlobalizedMessage globalize(String key, Object[] args) {
         return new GlobalizedMessage(key, BUNDLE_NAME, args);
  }

}
