/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes.converters;


import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.mimetypes.util.GlobalizationUtil;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.log4j.Logger;

/**
 * The PreConvertHTML class represents a single row
 * in the pre_convert_html table.
 *
 * @author <a href="mailto:teeters@arsdigita.com">Jeff Teeters</a>
 * @version 1.0
 **/
public class PreConvertHTML extends DomainObject {
    public static final String versionId = "$Id";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.ui.authoring.PreConvertHTML";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    // Creates a s_logging category with name = to the full name of class
    private static Logger s_log =
        Logger.getLogger( PreConvertHTML.class.getName() );


    /**
     * Default constructor. The contained <code>DataObject</code> is
     * initialized with a new <code>DataObject</code> with an
     * <code>ObjectType</code> of "PreConvertHTML".
     **/
    public PreConvertHTML() { // throws DataObjectNotFoundException {
        super(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor. The contained <code>DataObject</code> is retrieved
     * from the persistent storage mechanism with an <code>OID</code>
     * specified by <i>oid</i>.
     *
     * @param oid The <code>OID</code> for the retrieved
     * <code>DataObject</code>.
     **/
    public PreConvertHTML(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    private final static String ID = "id";
    private final static String CONTENT = "content";

    public void setId(BigDecimal id) {
        set(ID, id);
    }

    public void setContent(byte[] content) {
        set(CONTENT, content);
    }

    //accessors
    public BigDecimal getId() {
        return (BigDecimal)get(ID);
    }

    public byte[] getContent() {
        Object obj = get(CONTENT);
        if (obj == null) {
            return EMPTY_BYTE_ARRAY;
        }

        if (obj instanceof byte[]) {
            return (byte[])obj;
        } else if (obj instanceof Blob) {
            try {
                Blob blob = (Blob)obj;
                return blob.getBytes(1L, (int)blob.length());
            } catch (SQLException sqle) {
                throw new UncheckedWrapperException( (String) GlobalizationUtil.globalize("mimetypes.ui.sql_error_in_getting_byte_content").localize(),   sqle);
            }
        } else {
            throw new RuntimeException( (String) GlobalizationUtil.globalize("mimetypes.ui.bad_getblob_datatype").localize() + obj.getClass());
        }
    }
}
