/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mail;

// JavaMail API
import javax.mail.Session;
import javax.mail.MessagingException;

/**
 * Extends the standard MimeMessage to supply the correct value for
 * MessageID on all outbound email.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/mail/MimeMessage.java#9 $
 */

final class MimeMessage extends javax.mail.internet.MimeMessage {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mail/MimeMessage.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Constants

    private static final String MESSAGE_ID = "Message-ID";

    private String m_messageID;

    /**
     * Default constructor.
     */

    public MimeMessage (Session session) {
        super(session);
    }

    /**
     * Called by the saveChanges() method to update the MIME headers.
     */

    protected void updateHeaders()
        throws MessagingException
    {
        super.updateHeaders();

        if (m_messageID != null) {
            try {
                setHeader(MESSAGE_ID, m_messageID);
            } catch (MessagingException mex) {
                // ignore
            }
        }
    }

    public void setMessageID(String messageID) {
        m_messageID = messageID;
    }

}
