/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mail;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.URLParameter;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

/**
 * MailConfig
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public final class MailConfig extends AbstractConfig {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mail/MailConfig.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Properties m_props;

    private final Parameter m_debug = new BooleanParameter
        ("waf.mail.debug", Parameter.OPTIONAL, Boolean.FALSE);

    private final Parameter m_javamail = new PropertyFileParameter
        ("waf.mail.javamail.configuration", Parameter.OPTIONAL, null);

    public MailConfig() {
        register(m_javamail);
        register(m_debug);

        loadInfo();
    }

    public Properties getJavamail() {
        if (m_props == null) {
            URL propsFile = (URL) get(m_javamail);
            if (propsFile == null) {
                m_props = new Properties();
                m_props.put("mail.transport.protocol", "smtp");
                m_props.put("mail.smtp.host", "localhost");
            } else {
                try {
                    m_props = PropertyFileParameter.getProperties(propsFile);
                } catch (IOException ioe) {
                    throw new UncheckedWrapperException
                        ("unable to retrieve properties file from "
                         + propsFile, ioe);
                }
            }
        }

        return m_props;
    }

    public boolean isDebug() {
        return get(m_debug).equals(Boolean.TRUE);
    }

    private static class PropertyFileParameter extends URLParameter {
        PropertyFileParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
        }

        protected void doValidate(Object value, ErrorList errors) {
            super.doValidate(value, errors);

            if (!errors.isEmpty()) {
                return;
            }

            try {
                getProperties((URL) value);
            } catch (IOException ioe) {
                errors.add(new ParameterError(this, ioe));
            }
        }

        public static Properties getProperties(URL url) throws IOException {
            Properties props = new Properties();
            props.load(url.openStream());
            return props;
        }
    }

}
