/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.lucene;

import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;

/**
 * @deprecated moved to com.arsdigita.search.lucene
 * @see com.arsdigita.search.lucene.LuceneSearch
 **/
public class LuceneSearch 
    extends com.arsdigita.search.lucene.LuceneSearch {

    /**
     * Search over all objects in the system. Returns objects that matches
     * the search string.
     *
     * @param searchString user specified search string
     **/
    public LuceneSearch(String searchString) {
        super(searchString);
    }

    /**
     * Search for a specific ACS object and search string.
     *
     * @param searchString user specified search string
     * @param objectType ACS object type
     **/
    public LuceneSearch(String searchString, String objectType) {
        super(searchString, objectType);
    }

    /**
     * Search over all objects in the system using a filter
     *
     * @param searchString user specified search string
     * @param f a filter
     **/
    public LuceneSearch(String searchString, Filter f) {
        super(searchString, f);
    }

    /**
     * Search given a preformed query.
     *
     * @param q a performed query
     **/
    public LuceneSearch(Query q) {
        super(q);
    }
}
