/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.logging;

import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

/**
 * <p>
 * Defines a log4j filter that will filter out any messages that
 * are tagged as secure by the Log class.
 * </p>
 *
 * @author Yon Feldman 
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class SecureLogFilter extends Filter {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/logging/SecureLogFilter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Decides whether to let this log message go through.
     *
     * @param event a LoggingEvent to decide about letting go through
     */
    public int decide(LoggingEvent event) {
        // in here we have to check whether secure logging is on or off.
        if(Log.isSecure())
            return Filter.DENY;
        return Filter.NEUTRAL;
    }

    /**
     * Filter that does not support any options.
     */
    public String[] getOptionStrings() {
        return new String[] {"", ""};
    }

    /**
     * Filter that does not support any options.
     */
    public void setOption(String key, String value) {}
}
