/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.kernel.Resource;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.PageState;
import org.apache.log4j.Logger;

/**
 * <p>A base class used to implement the UI callbacks on {@link
 * com.arsdigita.kernel.ResourceTypeConfig}.</p>
 *
 * @see com.arsdigita.kernel.ResourceTypeConfig
 * @see com.arsdigita.kernel.ResourceType
 * @see com.arsdigita.kernel.Resource
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 * @author Eric Lorenzo
 */
public abstract class ResourceConfigFormSection extends FormSection {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/ui/ResourceConfigFormSection.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ResourceConfigFormSection.class);

    public ResourceConfigFormSection() {
        super();
    }

    public ResourceConfigFormSection(Container panel) {
        super(panel);
    }

    protected ResourceConfigFormSection(Container panel, FormModel model) {
        super(panel, model);
    }

    /**
     * This method is only called on ResourceConfigFormSections
     * that have been retrieved through the getCreateFormSection
     * method on ResourceTypeConfig. The application should be
     * initialized, but not saved.
     */
    public Resource createResource(PageState ps) {
        throw new UnsupportedOperationException();
    }

    /**
     * This method is only called on ResourceConfigFormSections
     * that have been retrieved through the getModifyFormSection
     * method on ResourceTypeConfig. The application modified is
     * the one specified in the RequestLocal argument to the
     * getModifyFormSection method.  The application can be modified
     * and saved, but it does not have to be saved.
     */
    public void modifyResource(PageState ps) {
        throw new UnsupportedOperationException();
    }
}
