/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import com.arsdigita.bebop.parameters.StringParameter;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/**
 * Logs in a user if the user has a valid authentication URL parameter.
 *
 * @author Sameer Ajmani
 **/
public class URLLoginModule extends UserLoginModule {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/URLLoginModule.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(URLLoginModule.class.getName());

    /**
     * ParameterModel for non-secure user authentication URL parameter.
     **/
    private static final StringParameter NORMAL_PARAM
        = new StringParameter(NORMAL_CREDENTIAL_NAME);

    /**
     * ParameterModel for secure user authentication URL parameter.
     **/
    private static final StringParameter SECURE_PARAM
        = new StringParameter(SECURE_CREDENTIAL_NAME);

    private static Set s_models = new HashSet();
    static {
        s_models.add(NORMAL_PARAM);
        s_models.add(SECURE_PARAM);
    }

    /**
     * Creates a UserLoginModule that uses a URLManager to manage the
     * credential value.
     **/
    public URLLoginModule() {
        super(new URLManager(s_models));
    }
}
