/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import java.io.File;

/**
 * SecurityConfig
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public class SecurityConfig extends AbstractConfig {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/SecurityConfig.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final Parameter m_rootPage       = new StringParameter
        ("waf.pagemap.root", Parameter.REQUIRED, "register/");
    private final Parameter m_loginPage      = new StringParameter
        ("waf.pagemap.login", Parameter.REQUIRED, "register/");
    private final Parameter m_newUserPage    = new StringParameter
        ("waf.pagemap.newuser", Parameter.REQUIRED, "register/new-user");
    private final Parameter m_logoutPage     = new StringParameter
        ("waf.pagemap.logout", Parameter.REQUIRED, "register/logout");
    private final Parameter m_cookiesPage    = new StringParameter
        ("waf.pagemap.cookies", Parameter.REQUIRED, "register/explain-persistent-cookies");
    private final Parameter m_changePage     = new StringParameter
        ("waf.pagemap.change", Parameter.REQUIRED, "register/change-password");
    private final Parameter m_recoverPage    = new StringParameter
        ("waf.pagemap.recover", Parameter.REQUIRED, "register/recover-password");
    private final Parameter m_expiredPage    = new StringParameter
        ("waf.pagemap.expired", Parameter.REQUIRED, "register/login-expired");
    private final Parameter m_workspacePage  = new StringParameter
        ("waf.pagemap.workspace", Parameter.REQUIRED, "pvt/");
    private final Parameter m_loginRedirectPage  = new StringParameter
        ("waf.pagemap.login_redirect", Parameter.REQUIRED, "pvt/");
    private final Parameter m_permissionPage = new StringParameter
        ("waf.pagemap.permission", Parameter.REQUIRED, "permissions/");
    private final Parameter m_permSinglePage = new StringParameter
        ("waf.pagemap.perm_single", Parameter.REQUIRED, "permissions/one");


    public SecurityConfig() {
        register(m_rootPage);
        register(m_loginPage);
        register(m_newUserPage);
        register(m_logoutPage);
        register(m_cookiesPage);
        register(m_changePage);
        register(m_recoverPage);
        register(m_expiredPage);
        register(m_workspacePage);
        register(m_loginRedirectPage);
        register(m_permissionPage);
        register(m_permSinglePage);
        loadInfo();
    }

    String getRootPage() {
        return (String) get(m_rootPage);
    }
    String getLoginPage() {
        return (String) get(m_loginPage);
    }
    String getNewUserPage() {
        return (String) get(m_newUserPage);
    }
    String getLogoutPage() {
        return (String) get(m_logoutPage);
    }
    String getCookiesPage() {
        return (String) get(m_cookiesPage);
    }
    String getChangePage() {
        return (String) get(m_changePage);
    }
    String getRecoverPage() {
        return (String) get(m_recoverPage);
    }
    String getExpiredPage() {
        return (String) get(m_expiredPage);
    }
    String getWorkspacePage() {
        return (String) get(m_workspacePage);
    }
    public String getLoginRedirectPage() {
        return (String) get(m_loginRedirectPage);
    }
    String getPermissionPage() {
        return (String) get(m_permissionPage);
    }
    String getPermSinglePage() {
        return (String) get(m_permSinglePage);
    }

}
