/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import javax.servlet.http.HttpServletRequest;

/**
 *  Implementation of the
 * SecurityHelper interface that always returns <code>true</code> for
 * <code>isSecure</code>.  This implementation is not safe, since it may
 * cause the system to send sensitive data over an insecure connection.
 * This class is used for simulating secure conditions for testing.
 *
 * @author Sameer Ajmani
 * @see SecurityHelper
 **/
public class  ParanoidSecurityHelper extends DefaultSecurityHelper {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/ParanoidSecurityHelper.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Always returns true (to simulate secure conditions).
     *
     * @return <code>true</code>.
     **/
    public boolean isSecure(HttpServletRequest req) {
        return true;
    }
}
