/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import org.apache.log4j.Logger;

/**
 * Logs in a user if the user has a valid authentication cookie.
 *
 * @author Sameer Ajmani
 **/
public class CookieLoginModule extends UserLoginModule {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/CookieLoginModule.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(CookieLoginModule.class.getName());

    /**
     * Creates a UserLoginModule that uses a CookieManager to manage the
     * credential value.
     **/
    public CookieLoginModule() {
        super(new CookieManager());
    }
}
