/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.OID;

/**
 * 
 * This interface is used by the URLService to delegate the
 * job of finding a URL for a domain object to custom code.
 *
 * <p>
 * If a developer adds a new data object type and wants
 * the URLService to support it, the
 * developer must register a URLFinder for the new type
 * using URLService.registerFinder().
 * <P>
 * The GenericURLFinder may be
 * used for many object types.  If the behavior of GenericURLFinder
 * is not applicable to some data object type, the developer
 * should write a new URLFinder that uses application-specific logic.
 *
 * @author Oumi Mehrotra 
 **/
public interface URLFinder {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/URLFinder.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Returns a URL path to a page that displays the object identified by
     * the given OID. The URL path is relative to the server root.
     * Only called from URLService.locate(OID).
     *
     * @throws NoValidURLException when no valid URL could be obtained
     * for the given OID.
     *
     * @see URLService#locate(OID)
     **/
    public String find(OID oid) throws NoValidURLException;
    public String find(OID oid, String context) throws NoValidURLException;

}
