/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.security.SessionContext;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.dispatcher.InitialRequestContext;
import com.arsdigita.dispatcher.RequestContext;
import org.apache.log4j.Logger;

public class KernelRequestContext extends InitialRequestContext {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/KernelRequestContext.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_cat =
        Logger.getLogger(KernelRequestContext.class.getName());

    private SessionContext m_session;
    private UserContext m_user;

    public KernelRequestContext(RequestContext parent,
                                SessionContext session,
                                UserContext user) {
        super(parent);
        m_session = session;
        m_user = user;
    }

    /**
     * Copy constructor.
     **/
    protected KernelRequestContext(KernelRequestContext that) {
        this(that, that.m_session, that.m_user);
    }

    public SessionContext getSessionContext() {
        return m_session;
    }

    public UserContext getUserContext() {
        return m_user;
    }
}
