/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.kernel.security.SessionContext;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.dispatcher.BaseDispatcherServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * Extends BaseDispatcherServlet to include functionality for
 * user authentication, which is part of Kernel.  Any ACS entry point
 * that needs to authenticate the currently logged-in user should
 * extend this class.
 */
public abstract class KernelDispatcherServlet extends BaseDispatcherServlet {

    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/KernelDispatcherServlet.java#7 $";

    private static final Logger s_cat =
        Logger.getLogger(KernelDispatcherServlet.class.getName());

    public void init() throws ServletException {
        super.init();
    }

    protected RequestContext authenticateUser(HttpServletRequest req,
                                              HttpServletResponse res,
                                              RequestContext ctx)
        throws RedirectException {
        UserContext user = new UserContext(req, res);
        SessionContext session = user.getSessionContext();
        return new KernelRequestContext(ctx, session, user);
    }
}
