/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import java.util.Locale;

/**
 * <p>
 * Defines the API required for defining a locale provider class. You can
 * register LocaleProviders with the {@link LocaleNegotiator} as a specific
 * type of LocaleProvider. Types are: Application preferred locale provider,
 * user preferred locale provider, client preferred locale provider, and
 * system preferred locale provider.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public interface LocaleProvider {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/LocaleProvider.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * <p>
     * Get the provided Locale.
     * </p>
     *
     * @return Locale, The provided Locale.
     */
    public abstract Locale getLocale();
}
