/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import java.util.Enumeration;

/**
 *  This is an interface that make sure that the implementing class
 *  provides access to the handleGetObject and the getKeys method
 *  of ResourceBundle
 */
public interface ChainableResourceBundle {

    /**
     *  This is the public version of ResourceBundle.handleGetObject(String key)
     *  which normally has protected access.  If you have a PropertyResourceBundle
     *  or a ListResourceBundle, this will simply delegate to the
     *  handleGetObject(String key) method.
     */
    public Object handleGetObject(String key);

    /**
     *  This is the public version of ResourceBundle.getKeys()
     *  which normally has protected access.  If you have a PropertyResourceBundle
     *  or a ListResourceBundle, this will simply delegate to the
     *  getKeys() method.
     */
    public Enumeration getKeys();
}
