/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

/**
 * <p>
 * Abstract class that represents a generic Accept HTTP header field.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class AcceptField implements Comparable {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/AcceptField.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // default quality value
    protected final static int DEFAULT_Q_VALUE = 1;

    protected double m_qvalue = DEFAULT_Q_VALUE;

    public double getQValue() {
        return m_qvalue;
    }

    protected void setQValue(String q) {
        int eq = q.indexOf('=');

        if (eq > -1) {
            setQValue(Double.parseDouble(q.substring(eq +1)));
        }
    }

    protected void setQValue(double q) {
        m_qvalue = q;
    }

    public int compareTo(Object o) {
        int rv;

        if (getQValue() < ((AcceptField) o).getQValue()) {
            rv = 1;
        } else if (getQValue() > ((AcceptField) o).getQValue()) {
            rv = -1;
        } else {
            rv = 0;
        }

        return rv;
    }
}
