/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import java.util.Locale;

/**
 * <p>
 * Represents one of possibly many of the values of the Accept-Charset HTTP
 * header.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class AcceptCharset extends AcceptField {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/AcceptCharset.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String DEFAULT_CHARSET = "ISO-8859-1";

    private String m_charset = "";

    /**
     * <p>
     * Constructor.
     * </p>
     *
     * @param acceptCharset String representing one entry from the
     *        Accept-Charset HTTP headers. This can look like: "en" or "en; q=0.75" or "*"
     */
    public AcceptCharset(String acceptCharset) {
        if (acceptCharset == null) {
            throw new NullPointerException("acceptCharset cannot be null");
        }

        int semi = acceptCharset.indexOf(';');

        if (semi == -1) {
            setCharset(acceptCharset);
            setQValue(DEFAULT_Q_VALUE);
        } else {
            setCharset(acceptCharset.substring(0, semi));
            setQValue(acceptCharset.substring(semi + 1));
        }
    }

    public final String getCharset() {
        return m_charset;
    }

    private void setCharset(String charset) {
        charset = charset.trim().toUpperCase(Locale.ENGLISH);

        if (charset.equals("*")) {
            m_charset = DEFAULT_CHARSET;
        } else {
            m_charset = charset;
        }
    }
}
