/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.jsp;


import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import com.arsdigita.util.UncheckedWrapperException;


public class Parameter extends TagSupport {
    private String m_name;
    private String m_value;

    public int doStartTag()
        throws JspException {
        try {
            DefineForm form = (DefineForm)getParent();

            form.setVariable(m_name, m_value);
        } catch (ClassCastException ex) {
            throw new UncheckedWrapperException("<forms-define:parameter .../> tags must be within a <forms-define:form ...>...</forms-define:form> block", ex);
        }

        return super.doStartTag();
    }

    public void setName(String value) {
        m_name = value;
    }

    public void setValue(String value) {
        m_value = value;
    }
}
