/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;







import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.formbuilder.HiddenIDGenerator;


import java.math.BigDecimal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.formbuilder.PersistentWidget;


public class HiddenIDGeneratorForm extends WidgetForm {
    public HiddenIDGeneratorForm(String name,
                                 SingleSelectionModel form,
                                 SingleSelectionModel control) {
        super(name, form, control);
    }


    protected PersistentWidget getWidget() {
        return new HiddenIDGenerator();
    }

    protected PersistentWidget getWidget(BigDecimal id)
        throws DataObjectNotFoundException {

        return new HiddenIDGenerator(id);
    }

    /**
     *  This determines whether or not the "required value" radio group
     *  is part of the form.  This returns true and should be overridden
     *  by fields where it does not make sense to ask.  For instance,
     *  when the widget is a hidden field then asking if it is required
     *  or not does not make any logical sense so those widgets should
     *  return false.
     *
     *  This will always return the same value for a given widget no matter
     *  what state the widget is in.
     */
    protected boolean includeRequiredRadioGroup() {
        return false;
    } 
}
