/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 


import com.arsdigita.formbuilder.actions.ConfirmRedirectListener;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;

import com.arsdigita.bebop.event.FormSectionEvent;

import com.arsdigita.bebop.form.TextField;

import com.arsdigita.bebop.parameters.URLParameter;

import com.arsdigita.domain.DataObjectNotFoundException;



import java.math.BigDecimal;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.ColumnPanel;


public class ConfirmRedirectForm extends ProcessListenerForm {
    private TextField m_url;

    public ConfirmRedirectForm(String name,
                               SingleSelectionModel form,
                               SingleSelectionModel action) {
        super(name, form, action);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);

        m_url = new TextField(new URLParameter("url"));
        m_url.setSize(50);
        m_url.addValidationListener(new NotNullValidationListener());
        m_url.addValidationListener(new StringInRangeValidationListener(1, 160));
        section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.url")), ColumnPanel.RIGHT);
        section.add(m_url);
    }


    protected PersistentProcessListener getProcessListener() {
        return new ConfirmRedirectListener();
    }

    protected PersistentProcessListener getProcessListener(BigDecimal id)
        throws DataObjectNotFoundException {

        return new ConfirmRedirectListener(id);
    }

    protected void initWidgets(FormSectionEvent e,
                               PersistentProcessListener listener)
        throws FormProcessException {
        super.initWidgets(e, listener);

        ConfirmRedirectListener l = (ConfirmRedirectListener)listener;

        PageState state = e.getPageState();

        if (l == null) {
            m_url.setValue(state, "");
        } else {
            m_url.setValue(state, l.getUrl());
        }
    }

    protected void processWidgets(FormSectionEvent e,
                                  PersistentProcessListener listener)
        throws FormProcessException {
        super.processWidgets(e, listener);

        ConfirmRedirectListener l = (ConfirmRedirectListener)listener;

        FormData data = e.getFormData();
        String url = (String)data.get("url");
        l.setUrl(url);
    }
}
