/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentCheckboxGroup;
import java.math.BigDecimal;

public class CheckboxGroupEditor extends OptionGroupEditor {
    public CheckboxGroupEditor(String name,
                               SingleSelectionModel form,
                               SingleSelectionModel control) {
        super(name, form, control,
              new CheckboxGroupForm(name, form, control),
              new OptionEditor(control) {
                  protected PersistentOptionGroup getOptionGroup(BigDecimal id)
                      throws DataObjectNotFoundException {
                      return new PersistentCheckboxGroup(id);
                  }
              });
    }
}
