/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


// The class we are extending
import com.arsdigita.bebop.Page;

// If I get an Excpetion I can't deal with I throw this

// I am conjuring up a static method from a sub class with
// reflection

/**
 * This Page is the base Page that all Pages in the Form Builder
 * service extend. It will encapsulate all common properties of the
 * pages. All pages in the Form Builder package are singletons.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/TemplatePage.java#7 $
 *
 */
public abstract class TemplatePage extends Page {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/TemplatePage.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Right now I don't know which Components will be common to
     * my Pages. This constructor is used by all Form Builder Pages.
     * It sets the title of the Page, invokes the subclass specific
     * buildPage() method, finishes and locks the Page.
     */
    public TemplatePage(String pageTitle) {
        super(pageTitle);

        buildPage();

        // The component structure of Bebop pages is static. I tried not locking
        // the Page but got an Exception
        lock();
    }

    /**
     * This method builds the Component structure specific to a certain Page
     * in the Form Builder service.
     */
    protected abstract void buildPage();

    public abstract String getRelativeURL();
}
