/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;




// Bebop Components that we are populating the Page with
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;

// Never really used, but in some method signatures

// We retrieve relative page URLs from the dispatcher
import com.arsdigita.formbuilder.FormBuilderDispatcher;

// logging
import org.apache.log4j.Logger;


/**
 * This is the index (start) page of the Form Builder
 * service. It has a link to the FormPropertiesPage for adding new forms as
 * well as a list of already persisted forms. For each form in the
 * list there are three links - a view link, an edit link and a widget
 * add link (FormViewPage, FormEditPage, FormBuildingPage).
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/IndexPage.java#12 $
 */
public class IndexPage extends TemplatePage {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/IndexPage.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(IndexPage.class);

    private static IndexPage s_instance;

    private IndexPage() {
        super(getStaticTitle());
    }

    /**
     * Provide access to the single instance of this page.
     */
    public static IndexPage instance() {

        if (s_instance == null) {
            s_instance = new IndexPage();
        }

        return s_instance;
    }

    public static String getStaticTitle() {
        return "Form Builder";
    }

    public String getRelativeURL() {
        return "index" + FormBuilderDispatcher.getURLEnding();
    }

    protected void buildPage() {

        // Add a Label that explains what this service does
        // Should I use an internationalized Label here?
        Label introLabel = new Label("This is the Form Builder administration interface with which " +
                                     "HTML forms can be built by non-programmers and saved to the database. These forms " +
                                     "can then be used " +
                                     "in ACS applications later on. The Form Builder " +
                                     "service is based  on an API (in the package " +
                                     "<a href=\"http://developer.arsdigita.com/acs-java/doc/api\">com.arsdigita.formbuilder</a>) " +
                                     "that enables the persisting of Bebop forms. More documentation on this service will " +
                                     "appear shortly.");
        // There is HTML in the label that we don't want to quote
        introLabel.setOutputEscaping(false);
        add(introLabel);

        // I would like to have a separator here
        add(new Label(""));

        // Add the link to the FormPropertiesPage
        Link addLink = new Link("Add new Form",
                                FormPropertiesPage.instance().getRelativeURL());
        addLink.setVar(FormPropertiesPage.instance().m_pageMode.getName(),
                       "add");
        add(addLink);

        // Add the list of links to pages for viewing and editing forms already persisted
        add(new SimpleQuestionnaireList());
    }
}
