/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;

// Used in constructor to create data object in base class
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;

// ACS objects are identified by a number
import java.math.BigDecimal;

// The factory creates Bebop Components
import com.arsdigita.bebop.Label;

// Every PersistentComponentFactory can create a Bebop Component
import com.arsdigita.bebop.Component;

// ACS 5 uses Log4J for logging
import org.apache.log4j.Logger;


/**
 * This class is responsible for persisting Bebop Labels. The Label
 * is saved with the save() method. To resurrect the Label, use the constructor
 * taking the id of the saved Label and then invoke createComponent().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentLabel.java#9 $
 *
 */
public class PersistentLabel extends PersistentComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentLabel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(PersistentLabel.class.getName());

    /**
     * The fully qualified name of the underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Component";

    // *** Constructors -------------

    public PersistentLabel() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor that creates a new Label domain object
     * that can be persisted.
     */
    public PersistentLabel(String typeName) {
        super(typeName);
    }

    public PersistentLabel(ObjectType type) {
        super(type);
    }

    public PersistentLabel(DataObject obj) {
        super(obj);
    }

    /**
     * Constructor that retrieves an existing Label domain object
     * from the database.
     *
     * @param id The object id of the Label domain object to retrieve
     */
    public PersistentLabel(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    /**
     * To be used by extending classes when retrieving instance from the database.
     */
    public PersistentLabel(OID oID)
        throws DataObjectNotFoundException {

        super(oID);
    }

    public static PersistentLabel create(String label) {
        PersistentLabel l = new PersistentLabel();
        l.setup(label);
        return l;
    }

    protected void setup(String label) {
        setComponentAttribute("label", label);
    }

    /**
     * Create the Label whose persistence is managed
     * by this domain object.
     */
    public Component createComponent() {

        Label label = new Label(getComponentAttribute("label"));

        return label;
    }

    //*** Attribute Methods
    public void setLabel(String label) {
        setComponentAttribute("label", label);
    }

    public String getLabel() {
        return getComponentAttribute("label");
    }
}
