/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;

import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;



import org.apache.log4j.Logger;

/**
 * Registers the formbuilder package type and creates an instance
 * that is mounted under formbuilder (this is done only once).
 *
 * @author Peter Marklund
 * @version $Revision: #9 $ $Date: 2004/04/07 $ */

public class Initializer

    implements com.arsdigita.initializer.Initializer {

    private Configuration m_conf = new Configuration();

    private static final Logger log =
        Logger.getLogger(Initializer.class);

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/Initializer.java#9 $";

    public Initializer() throws InitializationException {

    }

    /**
     * Returns the configuration object used by this initializer.
     **/

    public Configuration getConfiguration() {
        return m_conf;
    }


    /**
     * Called on startup. Note. As you can not find a call
     * to this method in enterprise.ini, this method
     * may appear to execute mysteriously.
     * However, the process that runs through enterprise.ini
     * automitically calls the startup() method of any
     * class that implements com.arsdigita.util.initializer.Initializer
     * present in enterprise.ini
     *
     **/


    public void startup() {

        log.info("FormBuilder Initializer starting.");

        TransactionContext txn = SessionManager.getSession()
            .getTransactionContext();
        txn.beginTxn();
        checkFormBuilderSetup();

        txn.commitTxn();
    }

    private void checkFormBuilderSetup() {
        /* This checks to see if a package by this name
         * is present.  If it isn't, setupFormBuilder
         * will do the necessary setup such as add the
         * package type, package instance, site node
         * and style sheet.
         */
        try {
            log.debug("FormBuilder Initializer - verifying setup.");
            PackageType.findByKey("formbuilder");
        } catch (DataObjectNotFoundException e) {
            setupFormBuilder();
        }
    }


    private void setupFormBuilder() {
        log.debug("FormBuilder Initializer - setting up new package");

        /** Adding the package type to the installation
         */

        PackageType FormBuilderType = PackageType.create
            ("formbuilder", "Form Builder", "Form Builders",
             "http://arsdigita.com/formbuilder");
        log.debug("Just added package type FormBuilder");


        /** Adding the node and the package instance
         *  on that node.
         */

        SiteNode FormBuilderTypeNode = SiteNode.createSiteNode("formbuilder");
        PackageInstance formBuilder = FormBuilderType.createInstance("FormBuilderType");

        /** Specifying the URL stub for this package instance.
         */
        FormBuilderTypeNode.mountPackage(formBuilder);
        FormBuilderTypeNode.save();


        /** Adding a style sheet
         */

        Stylesheet FormBuilderSheet = Stylesheet.createStylesheet ("/packages/formbuilder/xsl/formbuilder.xsl");
        FormBuilderType.addStylesheet(FormBuilderSheet);


        /** Mapping the package type to a dispatcher
         *  class
         */

        FormBuilderType.setDispatcherClass("com.arsdigita.formbuilder.FormBuilderDispatcher");

        /** Saving changes
         */

        FormBuilderType.save();

    }

    /**
     * Called on shutdown. It's probably not a good idea to depend on this
     * being called.
     **/

    public void shutdown() {
    }

}
