/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.PersistenceException;

/**
 * This exception is thrown by {@link DomainObjectFactory} when
 * it is unable to find an instantiator for a given <code>DataObject</code>.
 *
 * @author Stanislav Freidin 
 * @version $Revision: #7 $
 */

public class InstantiatorNotFoundException extends PersistenceException {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/InstantiatorNotFoundException.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor for an InstantiatorNotFoundException which does not wrap
     * another exception.
     */
    public InstantiatorNotFoundException(String message) {
        super(message);
    }

    /**
     * Constructor which takes a root cause
     * that this exception will be wrapping.
     */
    protected InstantiatorNotFoundException(Throwable rootCause) {
        super(rootCause);
    }

    /**
     * Constructor which takes a message string and a root cause
     * that this exception will be wrapping.  The message string
     * should be something different than rootCause.getMessage()
     * would normally provide.
     */
    protected InstantiatorNotFoundException(String s, Throwable rootCause) {
        super(s, rootCause);
    }

}
