/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;

/**
 * Wraps a {@link DomainCollection} as an {@link Iterator}
 *
 * NOTE:
 * This iterator reads an entire DomainCollection into memory and stores in an internal container.
 * Asside from being inefficient & preventing the use of filters, this can potentially cause data aliasing problems
 * in pre 5.3 core. Should only be used for passing to systems that don't directly support DomainCollections.
 *
 * @author Stanislav Freidin
 * @version $Id: //core-platform/dev/src/com/arsdigita/domain/DomainCollectionIterator.java#9 $
 */

public class DomainCollectionIterator implements Iterator {

    private List m_collection = new LinkedList();
    private Iterator m_iterator;

    /**
     * Wrap the specified <code>DomainCollection</code> in an iterator
     */
    public DomainCollectionIterator(DomainCollection c) {

        try {
            while (c.next()) {
                m_collection.add(c.getDomainObject());
            }

            m_iterator = m_collection.iterator();
        } finally {
            c.close();
        }

    }

    /**
     * Return true if there are more rows in the collection, false otherwise
     */
    public boolean hasNext() {
        return m_iterator.hasNext();
    }

    /**
     * Return the current domain object
     */
    public Object next() {
        return m_iterator.next();
    }

    /**
     * Not Implemented
     */
    public void remove() {
        throw new UnsupportedOperationException("Not Implemented");
    }
}
