/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.DataCollection;


/**
 * This is the base class that all other persistent collection classes
 * would extend. It provides navigation methods that delegate to a
 * contained <code>DataCollection</code>.
 *
 * @author Phong Nguyen
 * @version 1.0
 *
 * @see com.arsdigita.persistence.DataCollection
 **/
public class DomainCollection extends DomainQuery {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/DomainCollection.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected final DataCollection m_dataCollection;

    /**
     * Constructor.
     *
     * @see com.arsdigita.persistence.DataCollection
     **/
    public DomainCollection(DataCollection dataCollection) {
        super(dataCollection);
        m_dataCollection = dataCollection;
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     * @see DomainObject
     **/
    public DomainObject getDomainObject() {
        return
            DomainObjectFactory.newInstance(m_dataCollection.getDataObject());
    }
}
