/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dmi;

import org.apache.log4j.Logger;

/*
 *
 * @author Bryan Che (bche@redhat.com)
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 * @since CCM Core 5.2
 *
 */

public class ApplicationVersion {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dmi/ApplicationVersion.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(ApplicationVersion.class);

    private String m_sName;
    private String m_sUpgradeFile;
    private String m_sDescription;
    private String m_sPreviousVersionName;
    private boolean m_bUpgradeDataModel;

    public ApplicationVersion(String sName, boolean bUpgradeDataModel, String sUpgradeFile,
                              String sDescription, String sPreviousVersionName) {
        m_sName = sName;
        m_bUpgradeDataModel = bUpgradeDataModel;
        m_sUpgradeFile = sUpgradeFile;
        m_sDescription = sDescription;
        m_sPreviousVersionName = sPreviousVersionName;
    }

    public String getName() {
        return m_sName;
    }

    //does this version upgrade the data model from the previous version
    public boolean hasUpgradeDataModel() {
        return m_bUpgradeDataModel;
    }

    public String getUpgradeFile() {
        return m_sUpgradeFile;
    }

    public String getDescription() {
        return m_sDescription;
    }

    public String getPreviousVersionName() {
        return m_sPreviousVersionName;
    }
}
